/*
 * Decompiled with CFR 0.152.
 */
package lotr.common.item;

import java.util.List;
import java.util.Set;
import lotr.common.LOTRCreativeTabs;
import lotr.common.LOTRLevelData;
import lotr.common.LOTRPlayerData;
import lotr.common.entity.npc.LOTREntityHalfTroll;
import lotr.common.fac.LOTRFaction;
import lotr.common.item.LOTRMaterial;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemArmor;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.StringUtils;
import org.lwjgl.input.Keyboard;

public class LOTRItemArmor
extends ItemArmor {
    private LOTRMaterial lotrMaterial;
    private String extraName;

    public LOTRItemArmor(LOTRMaterial material, int slotType) {
        this(material, slotType, "");
    }

    public LOTRItemArmor(LOTRMaterial material, int slotType, String s) {
        super(material.toArmorMaterial(), 0, slotType);
        this.lotrMaterial = material;
        this.func_77637_a(LOTRCreativeTabs.tabCombat);
        this.extraName = s;
    }

    public LOTRMaterial getLOTRArmorMaterial() {
        return this.lotrMaterial;
    }

    public String getArmorTexture(ItemStack itemstack, Entity entity, int slot, String type) {
        String path = "lotr:armor/";
        if (entity instanceof LOTREntityHalfTroll) {
            path = "lotr:mob/halfTroll/";
        }
        String armorName = this.getArmorName();
        String texture = path + armorName;
        if (type != null) {
            texture = texture + "_" + type;
        }
        return texture + ".png";
    }

    private String getArmorName() {
        String suffix;
        String prefix = this.func_82812_d().name().substring("lotr".length() + 1).toLowerCase();
        String string = suffix = this.field_77881_a == 2 ? "2" : "1";
        if (!StringUtils.func_151246_b((String)this.extraName)) {
            suffix = this.extraName;
        }
        return prefix + "_" + suffix;
    }

    public boolean func_77645_m() {
        return this.lotrMaterial.isDamageable();
    }

    public void func_77624_a(ItemStack stack, EntityPlayer player, List list, boolean advanced) {
        LOTRPlayerData playerData;
        LOTRFaction pledgeFaction;
        if (player != null && (pledgeFaction = (playerData = LOTRLevelData.getData(player)).getPledgeFaction()) != null) {
            LOTRFaction.FactionType factionType = this.getPriorityFactionType(pledgeFaction.getFactionTypes());
            String factionName = pledgeFaction.factionName();
            EnumChatFormatting factionColor = this.getFactionColor(factionType);
            double factionMaxHealth = this.getMaxHealthForFaction(factionType);
            double playerMaxHealth = player.func_110138_aP();
            float reputation = playerData.getAlignment(pledgeFaction);
            if (Keyboard.isKeyDown((int)42) || Keyboard.isKeyDown((int)54)) {
                list.add(factionColor + I18n.func_135052_a((String)"item.armor.pledge", (Object[])new Object[]{factionName}));
                list.add("");
                list.add(EnumChatFormatting.GREEN + "\u2714 " + I18n.func_135052_a((String)"item.armor.health.max.current", (Object[])new Object[]{playerMaxHealth}));
                list.add(EnumChatFormatting.RED + "\u2764 " + I18n.func_135052_a((String)"item.armor.health.max.faction", (Object[])new Object[]{factionMaxHealth}));
                if (reputation < 5000.0f) {
                    list.add(EnumChatFormatting.GRAY + "\u2716 " + I18n.func_135052_a((String)"item.hammer.bonusDamage.info", (Object[])new Object[]{(int)reputation, "5000"}));
                } else {
                    switch (factionType) {
                        case TYPE_TREE: {
                            list.add(EnumChatFormatting.GOLD + "\u2716 " + I18n.func_135052_a((String)"effect.fireVulnerability", (Object[])new Object[]{"+50%"}));
                            break;
                        }
                        case TYPE_TROLL: {
                            list.add(EnumChatFormatting.GRAY + "\u272a " + I18n.func_135052_a((String)"effect.trollResistance", (Object[])new Object[]{"+15%"}));
                            break;
                        }
                        case TYPE_ELF: {
                            if (!(reputation >= 5000.0f)) break;
                            list.add(EnumChatFormatting.WHITE + "\u272a " + I18n.func_135052_a((String)"effect.snowWalker", (Object[])new Object[0]));
                            break;
                        }
                    }
                }
                if (factionType == LOTRFaction.FactionType.TYPE_ELF) {
                    list.add(EnumChatFormatting.DARK_GREEN + "\u2694 " + I18n.func_135052_a((String)"effect.poisonResistance", (Object[])new Object[]{"+50%"}));
                }
                if (factionType == LOTRFaction.FactionType.TYPE_TREE) {
                    list.add(EnumChatFormatting.DARK_RED + "\u2694 " + I18n.func_135052_a((String)"effect.bleedResistance", (Object[])new Object[]{"+50%"}));
                }
                if (factionType == LOTRFaction.FactionType.TYPE_TROLL) {
                    list.add(EnumChatFormatting.DARK_PURPLE + "\u2694 " + I18n.func_135052_a((String)"effect.brokenBoneResistance", (Object[])new Object[]{"+50%"}));
                }
            } else {
                list.add("");
                list.add(EnumChatFormatting.GRAY + I18n.func_135052_a((String)"item.armor.holdShift", (Object[])new Object[0]));
            }
        }
    }

    private EnumChatFormatting getFactionColor(LOTRFaction.FactionType factionType) {
        switch (factionType) {
            case TYPE_ORC: {
                return EnumChatFormatting.RED;
            }
            case TYPE_ELF: {
                return EnumChatFormatting.AQUA;
            }
            case TYPE_DWARF: {
                return EnumChatFormatting.GOLD;
            }
            case TYPE_MAN: {
                return EnumChatFormatting.YELLOW;
            }
            case TYPE_TROLL: {
                return EnumChatFormatting.DARK_PURPLE;
            }
            case TYPE_TREE: {
                return EnumChatFormatting.GREEN;
            }
        }
        return EnumChatFormatting.WHITE;
    }

    private double getMaxHealthForFaction(LOTRFaction.FactionType factionType) {
        switch (factionType) {
            case TYPE_ORC: {
                return 24.0;
            }
            case TYPE_ELF: {
                return 30.0;
            }
            case TYPE_MAN: {
                return 24.0;
            }
            case TYPE_TREE: {
                return 34.0;
            }
            case TYPE_DWARF: {
                return 26.0;
            }
            case TYPE_TROLL: {
                return 30.0;
            }
        }
        return 20.0;
    }

    private LOTRFaction.FactionType getPriorityFactionType(Set<LOTRFaction.FactionType> factionTypes) {
        if (factionTypes.contains((Object)LOTRFaction.FactionType.TYPE_ELF)) {
            return LOTRFaction.FactionType.TYPE_ELF;
        }
        if (factionTypes.contains((Object)LOTRFaction.FactionType.TYPE_DWARF)) {
            return LOTRFaction.FactionType.TYPE_DWARF;
        }
        if (factionTypes.contains((Object)LOTRFaction.FactionType.TYPE_TREE)) {
            return LOTRFaction.FactionType.TYPE_TREE;
        }
        if (factionTypes.contains((Object)LOTRFaction.FactionType.TYPE_MAN)) {
            return LOTRFaction.FactionType.TYPE_MAN;
        }
        if (factionTypes.contains((Object)LOTRFaction.FactionType.TYPE_ORC)) {
            return LOTRFaction.FactionType.TYPE_ORC;
        }
        if (factionTypes.contains((Object)LOTRFaction.FactionType.TYPE_TROLL)) {
            return LOTRFaction.FactionType.TYPE_TROLL;
        }
        return LOTRFaction.FactionType.TYPE_FREE;
    }
}

